#################################################################################
# Author      : Webkul Software Pvt. Ltd. (<https://webkul.com/>)
# Copyright(c): 2015-Present Webkul Software Pvt. Ltd.
# All Rights Reserved.
#
#
#
# This program is copyright property of the author mentioned above.
# You can`t redistribute it and/or modify it.
#
#
# You should have received a copy of the License along with this program.
# If not, see <https://store.webkul.com/license.html/>
#################################################################################

from . import controller
from . import models
from . import wizard

def pre_init_check(cr):
    from odoo.release import series
    from odoo.exceptions import ValidationError
    
    if not 17.0 < float(series) <= 18.0:
        raise UserError(f'Module support Odoo series 18.0 but found {series}.')

def uninstall_hook(env):
    """ This method will remove all the custom redirects which are created by seo url keys. """
    redirect_to_clean = env['website.rewrite'].search(
            [('rewrite_val', 'in', ['product.template', 'product.public.category'])])
    redirect_to_clean.unlink()

